# Load the necessary libraries
install.packages("caret")
library(stats)
library(caret)
# Create a sample dataset
data <- data.frame(
  x1 = c(1, 2, 3, 4, 5),
  x2 = c(5, 4, 3, 2, 1),
  x3 = c(2, 3, 1, 5, 4)
)
# Define the hyperparameter grid for PCA
param_grid <- expand.grid(
  center = c(TRUE, FALSE),
  scale. = c(TRUE, FALSE)
)
# Initialize variables to store best hyperparameters and best RMSE
best_params <- NULL
best_rmse <- Inf
# Iterate over hyperparameter grid
for (i in 1:nrow(param_grid)) {
  center <- param_grid$center[i]
  scale <- param_grid$scale.[i]
  # Perform PCA
  pca_result <- prcomp(data, center = center, scale. = scale)
  # Calculate RMSE (example metric, can use others)
  rmse <- sqrt(sum(pca_result$sdev^2))
  # Update best hyperparameters if RMSE is lower
  if (rmse < best_rmse) {
    best_rmse <- rmse
    best_params <- c(center, scale)
  }
}

# Print the best hyperparameters
print(best_params)

# Perform PCA with the best hyperparameters
pca_result <- prcomp(data, center = best_params[1], scale. = best_params[2])
# View the PCA results
print(summary(pca_result))

# Screen plot
plot(pca_result)

# Biplot
biplot(pca_result)

# Project the data onto principal components
projected <- predict(pca_result)

# Reconstruct the original data
reconstructed <- projected %*% t(pca_result$rotation)

# Add back centering if applied
if (!is.null(pca_result$center)) {
  reconstructed <- sweep(reconstructed, 2, pca_result$center, "+")
}

# Rescale if scaling was applied
if (!is.null(pca_result$scale)) {
  reconstructed <- sweep(reconstructed, 2, pca_result$scale, "*")
}

# Compute reconstruction error
reconstruction_error <- mean((as.matrix(data) - reconstructed)^2)
cat("Reconstruction Error (MSE):", reconstruction_error, "\n")